﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    /// <summary>
    /// 言語選択DDL
    /// </summary>
    public class LangDropDownList : Framework.Web.UI.MDropDownList
    {
        public string _className ;

        /// <summary>
        /// 選択変更後にページの再表示を行うかどうか
        /// </summary>
        public bool AllowPageRefresh { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LangDropDownList()
        {
            _className = this.GetType().FullName;

            this.ListKey = _className;
            base.AutoPostBack = true;
            this.AllowPageRefresh = true;
        }

        /// <summary>
        /// OnSelectedIndexChanged
        /// </summary>
        /// <param name="e"></param>
        protected override void OnSelectedIndexChanged(EventArgs e)
        {
            if (base.AutoPostBack == true)
            {
                Lang.Current = this.SelectedValue;
            }

            //OnSelectedIndexChanged
            base.OnSelectedIndexChanged(e);

            if (this.AllowPageRefresh == true)
            {
                this.Page.Response.Redirect(this.Page.Request.Url.PathAndQuery);
            }
        }

        /// <summary>
        /// リスト値をセットして、その後dataに応じて項目の選択状態を変えます。
        /// </summary>
        /// <param name="data"></param>
        override public void SetMappingData(Framework.Data.MappingData data)
        {
            base.SetMappingData(data);

            var cur = Lang.CurrentCulture;

            foreach (ListItem item in this.Items)
            {
                if (item.Value == cur.Name || item.Value == cur.TwoLetterISOLanguageName)
                {
                    item.Selected = true;
                    break;
                }
            }
        }

    }
}
